/**
 * Scripts for admin area
 */

// Parse GET params
var urlParams;
(window.onpopstate = function () {
    var match,
        pl     = /\+/g,  // Regex for replacing addition symbol with a space
        search = /([^&=]+)=?([^&]*)/g,
        decode = function (s) { return decodeURIComponent(s.replace(pl, " ")); },
        query  = window.location.search.substring(1);

    urlParams = {};
    while (match = search.exec(query))
       urlParams[decode(match[1])] = decode(match[2]);
})();

function selectText(containerid) {
    if (document.selection) {
        var range = document.body.createTextRange();
        range.moveToElementText(document.getElementById(containerid));
        range.select();
    } else if (window.getSelection()) {
        var range = document.createRange();
        range.selectNode(document.getElementById(containerid));
        window.getSelection().removeAllRanges();
        window.getSelection().addRange(range);
    }
}

function escapeHtml(text) {
  var map = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#039;'
  };

  return text.replace(/[&<>"']/g, function(m) { return map[m]; });
}

jQuery(document).ready(function($){

	var thisIsAPostPage = false;
	var thisIsASettingsPage = false;
	var thisIsAListPage	= false;

	// Media uploader
	var file_frame, image_data;

	// URL after # sign
	var hash = window.location.hash;

	// Check if this is a "New Content Upgrade Post" page
	// with URL /wp-admin/post-new.php?post_type=aops_content_upgrade
	if (typeof(urlParams['post_type']) !== 'undefined') {
		if (urlParams['post_type'] === 'aops_content_upgrade') {

			// Not to mix with the Settings page,
			// with URL l/wp-admin/edit.php?post_type=aops_content_upgrade&page=aops-cu-settings
			if (typeof(urlParams['page']) !== 'undefined') {
				if (urlParams['page'] === 'aops-cu-settings') {
					thisIsAPostPage = false;
					thisIsASettingsPage = true;
				}
			}
			else {
				if (document.getElementById('aops_bonus_content_path')) { // check if some of CU fields is present
					thisIsAPostPage = true;
				}
				else if (document.getElementById('bulk-titles')) { //check is this is a CU list page
					thisIsAListPage	= true;
				}
			}
		}
	}

	// function to show/hide table rows after checkbox was checked/unchecked
	var handleCheckboxChange = function($this, targets) {
		var checked = $this.attr('checked');

		$targets = [];
		for (var i in targets) {
			if (typeof targets[i] === 'string') { // e.g. '#aops_action_text_top'
				$targets.push(
					jQuery(targets[i]).parent().parent() // input -> td -> tr
				);
			}
			else { // array , e.g. ['#aops_action_text_top','tr']
				$targets.push(
					jQuery(targets[i][0]).parents(targets[i][1]) // input -> (custom parent element)
				);
			}
		}

		if (checked === 'checked') {
			for (var i in targets) { $targets[i].show("slow"); };
		}
		else {
			for (var i in targets) { $targets[i].hide();	};
		}
	};


	var saveBulkEdit = function() {
		var $bulk_row = jQuery('#bulk-edit');

		// get the selected post ids that are being edited
		var cu_ids = new Array();
		$bulk_row.find('#bulk-titles').children().each( function() {
			cu_ids.push(
				jQuery(this).attr('id').replace( /^(ttle)/i, '' )
			);
		});

		// get the new CU fields status
		var fields = [
			'cu_user_email_status',
			'cu_admin_email_status',
			'cu_exit_intent_status',
			'cu_download_status',
			'cu_sharing_status',
			'cu_ga_event_status'
		];

		var data = {cu_ids: cu_ids};

		jQuery.each( fields, function( index, fieldName ) {
			data[fieldName] = $bulk_row.find( 'select[name="' + fieldName + '"]' ).val();
		});

		// save the data
		jQuery.post( ajaxurl, {
			security: $( 'input#_wpnonce', '#posts-filter' ).val(),
			action: 'cu_save_bulk_edit',
			data: data
		});
	};

	// Check if this is a "Content Upgrade Post" page
	// with URL wp-admin/post.php?post=115&action=edit
	if (typeof(urlParams['post']) !== 'undefined') {
		if (typeof(urlParams['action']) !== 'undefined') {
			if (urlParams['action'] === 'edit') {
				if (document.getElementById('aops_bonus_content_path')) { // check if some of CU fields is present
					thisIsAPostPage = true;
				}
			}
		}
	}

	var tabRegexp = new RegExp("#tab_",'g');
	var hashRegexp = new RegExp("#cu_",'g');

	// Stuff to do on the "Edit Content Upgrade page"
	if (thisIsAPostPage) {
		if (!hash) {
			// Open tab that was opened before the post save/update
			var defaultOpenedTab = jQuery("#aops_last_opened_tab").val();

			if (defaultOpenedTab) {
				hashTab = defaultOpenedTab.replace(tabRegexp,'#cu_tab_');

				// Check whether this tab actually exists
				if (jQuery("#cu_tab_container ul.etabs li" + defaultOpenedTab).length > 0) {
					window.location.hash = hashTab;
				}
				else {
					defaultOpenedTab = false;
				}
			}

		}
		else {
			defaultOpenedTab = hash.replace(hashRegexp,'#');

			// Check whether this tab actually exists
			if (jQuery("#cu_tab_container ul.etabs li" + defaultOpenedTab).length > 0) {
				jQuery("#aops_last_opened_tab").val(defaultOpenedTab);
			}
			else {
				defaultOpenedTab = false;
			}


		}

		// Fallback to default tab
		if (!defaultOpenedTab) {
			defaultOpenedTab = "#tab_bonus";
			window.location.hash = '#cu_tab_bonus';
			jQuery("#aops_last_opened_tab").val(defaultOpenedTab);
		}

		// Determine whether Mailchimp tab is present
		if (jQuery("#tab_mailchimp").length > 0 ) {
			// Determine which mailchimp group to show
			var mailchimpList = jQuery("#aops_mailchimp_list").val();
			var mailchimpListExtra = jQuery("#aops_mailchimp_extra_list_id").val();

			if (mailchimpListExtra) {
				jQuery("#mailchimp_list_" + mailchimpListExtra).show();
			}
			else if (mailchimpList == 0) {
				jQuery("#mailchimp_list_none").show();
			}
			else {
				jQuery("#mailchimp_list_" + mailchimpList).show();
			}

			// Show groups onchange
			jQuery("#aops_mailchimp_list").change(function(){
				var selectedList = jQuery(this).val();
				jQuery(".mailchimp-list").hide();
				if (selectedList == 0) {
					jQuery("#mailchimp_list_none").show();
				}
				else {
					jQuery("#mailchimp_list_" + selectedList).show();
				}

			});
		}

		// Determine whether Drip tab is present
		if (jQuery("#tab_drip").length > 0 ) {

			var $checkboxTr = jQuery("#aops_drip_custom_event_name").parents('tr');

			// Determine whether to show "drip_custom_event_name" field
			if (jQuery("#aops_drip_custom_event_enabled:checked").length > 0) { // checkbox is checked
				$checkboxTr.show();
			}
			else {
				$checkboxTr.hide();
			}

			jQuery("#aops_drip_custom_event_enabled").on("click", function(){
				$checkboxTr.toggle();
			});
		}

		// Handle "Fire a Facebook conversion event..." checkbox change

		var showFacebookConversionEventName = function(){
			handleCheckboxChange(jQuery(this),[
				'#aops_facebook_conversion_event_name'
			]);
		};

		jQuery("#aops_facebook_conversion_event_enabled").on("change", showFacebookConversionEventName);

		// Handle "display Download	link immediately" checkbox change

		var showDownloadTextUnput = function(){
			handleCheckboxChange(jQuery(this),[
				['#aops_download_text',				'tr'],
				['#aops_share_buttons_enabled',		'tr'],
				['#aops_share_buttons_header_text',	'tr']
			]);
		};

		jQuery("#aops_download_enabled").on("change", showDownloadTextUnput);

		// Handle "Trigger a custom JavaScript event..." checkbox change

		var showCustomConversionEventTextbox = function(){
			handleCheckboxChange(jQuery(this),[
				'#aops_custom_conversion_event_code'
			]);
		};

		jQuery("#aops_custom_conversion_event_enabled").on("change", showCustomConversionEventTextbox);

		// Handle "Redirect user to a different page after they fill..." checkbox change

		var showRedirectUrlTextField = function(){
			handleCheckboxChange(jQuery(this),[
				'#aops_redirect_after_formfill_url'
			]);
		};

		jQuery("#aops_redirect_after_formfill_enabled").on("change", showRedirectUrlTextField);

	}
	else if (thisIsASettingsPage) {
		if (!hash) { // hash part of the URL is missing, so default opened tab should be determined setting stored in the field
			var defaultOpenedTab = jQuery("#aops_last_opened_settings_tab").val();

			if (defaultOpenedTab) {
				var hashTab = defaultOpenedTab.replace(tabRegexp,'#cu_tab_');

				// Check whether this tab actually exists
				if (jQuery("#cu_tab_container ul.etabs li" + defaultOpenedTab).length > 0) {
					window.location.hash = hashTab;
				}
				else {
					defaultOpenedTab = false;
				}
			}
		}
		else { // default opened tab should be determined by hash part of the URL
			defaultOpenedTab = hash.replace(hashRegexp,'#');

			// Check whether this tab actually exists
			if (jQuery("#cu_tab_container ul.etabs li" + defaultOpenedTab).length > 0) {
				jQuery("#aops_last_opened_settings_tab").val(defaultOpenedTab);
			}
			else {
				defaultOpenedTab = false;
			}
		}

		// Fallback to default tab for Settings Page
		if (!defaultOpenedTab) {
			defaultOpenedTab = '#tab_design';
			window.location.hash = '#cu_tab_design';
			jQuery("#aops_last_opened_settings_tab").val(defaultOpenedTab);
		}

		// Determine whether Mailchimp API key is OK
		if (jQuery("#aops_mailchimp_api_key").next().hasClass("check-result-ok")) {

			// Determine which mailchimp group to show
			var mailchimpList = jQuery("#aops_mailchimp_default_list").val();
			var mailchimpListExtra = jQuery("#aops_mailchimp_default_extra_list_id").val();

			if (mailchimpListExtra) {
				jQuery("#mailchimp_list_" + mailchimpListExtra).show();
			}
			else if (mailchimpList == 0) {
				jQuery("#mailchimp_list_none").show();
			}
			else {
				jQuery("#mailchimp_list_" + mailchimpList).show();
			}

			// Show groups onchange
			jQuery("#aops_mailchimp_default_list").change(function(){
				var selectedList = jQuery(this).val();
				jQuery(".mailchimp-list").hide();
				if (selectedList == 0) {
					jQuery("#mailchimp_list_none").show();
				}
				else {
					jQuery("#mailchimp_list_" + selectedList).show();
				}

			});
		}

		// Handle "Fire a Facebook conversion event..." checkbox change

		var showFacebookConversionEventName = function(){
			handleCheckboxChange(jQuery(this),[
				'#aops_facebook_conversion_event_name'
			]);
		};

		jQuery("#aops_facebook_conversion_event_enabled").on("change", showFacebookConversionEventName);

		// Handle "display Download	link immediately" checkbox change

		var showDownloadTextUnput = function(){
			handleCheckboxChange(jQuery(this),[
				['#aops_download_text',				'tr'],
				['#aops_share_buttons_enabled',		'tr'],
				['#aops_share_buttons_header_text',	'tr']
			]);
		};

		jQuery("#aops_download_enabled").on("change", showDownloadTextUnput);

		// Handle "Trigger a custom JavaScript event..." checkbox change

		var showGlobalConversionEventTextbox = function(){
			console.log('showGlobalConversionEventTextbox');
			handleCheckboxChange(jQuery(this),[
				'#aops_global_conversion_event_code'
			]);
		};

		jQuery("#aops_global_conversion_event_enabled").on("change", showGlobalConversionEventTextbox);


		// Handle "enable consent checkbox" checkbox change

		var showConsentCheckboxLabel = function(){
			handleCheckboxChange(jQuery(this),[
				'#aops_consent_checkbox_label'
			]);
		};

		jQuery("#aops_consent_checkbox_enabled").on("change", showConsentCheckboxLabel);

	}
	else if (thisIsAListPage) {
		jQuery('#bulk_edit').on( 'click', function() {
			saveBulkEdit();
		});
	}

	// by default "a.first-page" leads to the 1st page of the list table by link with no additional params
	// we add "?paged=1" to make sure that code above will detect that entries tas must be shown
	if (thisIsAPostPage) {
		var $firstPageLink = jQuery("a.first-page");
		$firstPageLink.attr('href', $firstPageLink.attr('href') + '&paged=1');
	}


	// activate tabs plugin
	jQuery('#cu_tab_container').easytabs({
		animate: false,
		defaultTab: defaultOpenedTab,
		updateHash: true
	});

	// Save name of the last opened tab to open it later after post save/update
	jQuery('#cu_tab_container').bind('easytabs:after', function() {
		jQuery("#cu_tab_container ul.etabs li").each(function(){
			$this = jQuery(this);

			if ($this.hasClass('active')) {
				var hashRegexp = new RegExp("#cu_",'g');
				var activeTabId = $this.find('a').attr("href").toString().replace(hashRegexp,'#');
				if (thisIsAPostPage) {
					jQuery("#aops_last_opened_tab").val(activeTabId);
				}
				else {
					jQuery("#aops_last_opened_settings_tab").val(activeTabId);
				}
			}
		});
	});

	jQuery('.cu_tab_link').click( function() {
		jQuery('#cu_tab_container').easytabs('select', jQuery(this).attr('href'));
	});

	// process fake links in tooltips
	// this is needed because tooltips are made by puse CSS, using a.aops-tooltip hover state
	// and tooltip itself is a link.
	jQuery('.tooltip-link').click(function(event){
		var href = jQuery(this).attr("href");
		document.location.href = href;
	});

	// Adds class to the first field row of a section, used for CSS styling to remove top-border
	$( "tr.ao-settings-header" ).next().addClass("ao-first-field-row");

	// process Color Picker input
	jQuery('.cu-color-picker').spectrum({
		showPalette: true,
		showInput: true,
		preferredFormat: "hex",
		palette: [
			["#000","#444","#666","#999","#ccc","#eee","#f3f3f3","#fff"],
			["#f00","#f90","#ff0","#0f0","#0ff","#00f","#90f","#f0f"],
			["#f4cccc","#fce5cd","#fff2cc","#d9ead3","#d0e0e3","#cfe2f3","#d9d2e9","#ead1dc"],
			["#ea9999","#f9cb9c","#ffe599","#b6d7a8","#a2c4c9","#9fc5e8","#b4a7d6","#d5a6bd"],
			["#e06666","#f6b26b","#ffd966","#93c47d","#76a5af","#6fa8dc","#8e7cc3","#c27ba0"],
			["#c00","#e69138","#f1c232","#6aa84f","#45818e","#3d85c6","#674ea7","#a64d79"],
			["#900","#b45f06","#bf9000","#38761d","#134f5c","#0b5394","#351c75","#741b47"],
			["#600","#783f04","#7f6000","#274e13","#0c343d","#073763","#20124d","#4c1130"]
		]
	});

	//Collapsible content in  Integration tab on Settings page
	new jQueryCollapse(jQuery("#settings_integrations"), {
		open: function() {
		  this.slideDown(150);
		  this.prev().find(".dashicons").removeClass('dashicons-arrow-right-alt2').addClass('dashicons-arrow-down-alt2');
		},
		close: function() {
		  this.slideUp(150);
		  this.prev().find(".dashicons").removeClass('dashicons-arrow-down-alt2').addClass('dashicons-arrow-right-alt2');
		}
	  });


	// Toggle hidden fields on click
	jQuery(".toggle_hidden_field").click(function(){
		var nameRegexp = new RegExp("toggle_",'g');
		var toggledElementName = jQuery(this).attr('id').replace(nameRegexp,'');

		jQuery(this).parents("table.form-table tr, table.form-table-wide tr").hide();
		//jQuery(this).parents("table.form-table-wide tr").hide();

		jQuery("#hidden_" + toggledElementName).show();
	});

	var bonus_content_selected = (jQuery('#bonus_content_path').val() != '') ? true : false;
	jQuery( '#upload_bonus_content_button' ).on( 'click', function( e ) {

		// Stop the anchor's default behavior
		e.preventDefault();

		// Display the media uploader

		/**
		 * If an instance of file_frame already exists, then we can open it
		 * rather than creating a new instance.
		 */
		if ( undefined !== file_frame ) {
			file_frame.open();
			return;
		}

		// Create the media frame.
        file_frame = wp.media.frames.downloadable_file = wp.media({
			// Set the title of the modal.
			title: 'Select File',
			button: {
				text: 'Use this content upgrade'
			},
			multiple: false
		});

		/**
		 * Setup an event handler for what to do when an image has been
		 * selected.
		 *
		 * Since we're using the 'view' state when initializing
		 * the file_frame, we need to make sure that the handler is attached
		 * to the insert event.
		 */
		file_frame.on( 'select', function() {
			var selection = file_frame.state().get('selection');

			selection.map( function( attachment ) {

				 attachment = attachment.toJSON();

				 if ( attachment.id ) {
					 bonus_content_selected = true;
					 jQuery('#aops_bonus_content_path').val(attachment.url);
					 jQuery('#upload_bonus_content_button').html('Update Bonus Content');
				 }
			})

		});

		// Now display the actual file_frame
		file_frame.open();

	});

});
